﻿/*
	VERSION:		1.1
	
	DESCRIPTION:
		This is a simple object-based music system.  (doesn't need a movieClip)
		It extends the Sound() class,  but you must use stopMusic() instead of stop().
	
	USAGE:
		#include "makeMusic.as"
		MUSIC = makeMusic();
		MUSIC.play( "songName" );
		
	FUNCTIONS:
		play( "songName" );
		plaIntro( "songName" );
		stopMusic();
		
	NOTE:
		Setting the volume of this will likely affect the audio volume of the entire movieClip!
		fadeOut()  has been disabled for this reason.
		This would have to be a movieClip-based system for volume to work properly.
*/
makeMusic = function()
{
	_this = new Sound();
	_this.volume = 100;
	_this.isPlaying = false;
	_this.songName = "";
	
	
	
	_this.play = function( songName )
	{
		if(_this.songName != songName)
		{
			_this.attachSound( songName );
			_this.songName = songName;
			_this.isPlaying = false;
		}// if: a new song is specified
		
		if( _this.isPlaying == false )
		{
			_this.start(0,9999);
			_this.volume = 100;
			_this.setVolume( _this.volume );
			_this.isPlaying = true;
		}// if:  music is not playing
	}// play()
	
	
	
	_this.stopMusic = function()
	{
		_this.stop();
		_this.isPlaying = false;
	}// stopMusic()
	
	
	
	// setVolume()
	
	
	/*
	_this.fadeOut = function( seconds )
	{
		if(_this.volume > 0  &&
		   _this.fade == undefined)
		{
			// tween volume from current to ZERO
			var startVolume = _this.getVolume();
			_this.fade = new mx.transitions.Tween( _this, "volume", null, startVolume, 0, seconds, true);
			
			// onChange
			_this.fade.onMotionChanged = function()
			{
				_this.setVolume( this.position );
			}// onMotionChanged()
			
			// onDone
			_this.fade.onMotionFinished = function()
			{
				delete _this.fade;
				_this.stopMusic();
			}// onMotionFinished()
		}// if:  volume isn't ZERO
	}// fadeOut()
	*/
	
	
	
	return _this;
}// makeMusic()